#ifndef	_DRAWJPEG_H
#define	_DRAWJPEG_H


/*
 * ///// definition of basic data type /////
 */
typedef	unsigned char	U1;
typedef	unsigned short	U2;
typedef unsigned long	U4;
typedef	char			I1;
typedef	short			I2;
typedef	long			I4;

#define	PREFERRED_DCT_METHOD    JDCT_IFAST		/* faster, less accurate integer method			*/
#if 0
#define	PREFERRED_DCT_METHOD    JDCT_ISLOW		/* slow but accurate integer algorithm			*/
#define	PREFERRED_DCT_METHOD    JDCT_FLOAT		/* floating-point: accurate, fast on fast HW	*/
#endif

#ifdef MOTOROLA
#define	VRAM_OTHER_ENDIAN
#endif	/* MOTOROLA */

#define	FMT_ERR			-2
#if 0
#define	DRAW_STOP		-3
#endif

/* image type */
#define	MEM_IMG       (0x0000)		/* image on memory							*/
#define	FILE_IMG      (0x8000)		/* image by specifying filename				*/
#define	IMG_TYP_JPEG  (0x0001)		/* JEPG image mode(already realized feature)*/
#define	IMG_TYP_THNMB (0x0002)		/* thumbnail image mode the first thumbnail
                                       image found as searched from the head of 
                                       data										*/

/* tone effect enable/disable */
#define	TONE_EFFECT_ENABLE		0	/* tone effect enable						*/
#define	TONE_EFFECT_DISABLE		1	/* tone effect disable						*/

/*
 * ///// definition of result vlaue /////
 */
#define	JPEG_SUCCESS			0x00000000
#define	JPEG_DRAW_STOP			0x00000001
#define	JPEG_FAILURE			0xFFFFFFFF


/* value which will be filled into the alphachannel */
#define JPEG_ALPHA_DEFAULT_ARGB8888     (0xff000000)          /* Fully opaque by default */

/*
 * ///// definition of RGB information /////
 */
/* bit range structure */
typedef struct {
	U1			bit_s;				/* bit start position			*/
	U1			bit_e;				/* bit end position				*/
} BIT_POS;

/* RGB information structure */
typedef struct _PIX_RGB {
	U2			size;				/* byte size per 1 pixel		*/
	BIT_POS		r;					/* bit range of red				*/
	BIT_POS		g;					/* bit range of green			*/
	BIT_POS		b;					/* bit range of blue			*/
} PIX_RGB;

/*
 * ///// definition of draw area information /////
 */
/* draw area information structure */
typedef struct	 _DRAW_AREA_INFO {
	I2			mwidth;				/* drawing memory width			*/
	PIX_RGB		rgb;				/* RGB structure of a pixel		*/
	struct {						/* vector structure				*/
		I2		x;					/* x value						*/
		I2		y;					/* y value						*/
	} size;							/* drawing area size			*/
	U1			*vram_adrs;			/* drawing start address of RAM */
} DRAW_AREA_INFO, *pDRAW_AREA_INFO;

/*
 * ///// definition of draw image information /////
 */
/* color palette data */
typedef unsigned char	IMG_PALETTE;

/* color palette setting structure */
typedef struct _PLT_INFO {
	U2			num;				/* amount of color palettes		*/
	U2			ofst;				/* palette offset				*/
	IMG_PALETTE	*plt_dat;			/* color palette data			*/
} PLT_INFO, *pPLT_INFO;

/* image effect structure */
typedef struct {
	struct {
		U1			effect_enable;	/* tone effect enable/disable	*/
		U1			U;				/* red ingredient				*/
		U1			V;				/* blue ingredient				*/
	} tone_effect;					/* tone effect structure		*/
	U2				rotation;		/* rotation angle				*/
} IMAGE_EFFECT;

/* draw image information structure */
typedef struct {
	U2				type;			/* image data kind				*/
	struct {						/* point structure				*/
		I4			x;				/* x value						*/
		I4			y;				/* y value						*/
	} org;							/* iamge cutout start origin	*/
	struct {						/* vector structure				*/
		I2			x;				/* x value						*/
		I2			y;				/* y value						*/
	} size;							/* cutout image size			*/
	U2				zx_zy;			/* scale						*/
	U1				*datap; 		/* data storage address			*/
	U4				datasize;		/* data storage size			*/
	PLT_INFO		*plt_info;		/* palette storage address		*/
	I4				zx;				/* x scale						*/
	I4				zy;				/* y scale						*/
	IMAGE_EFFECT	image_effect;	/* image effect					*/
	U1              revert;
} DRAW_IMG_INFO;

/* JPEG image information structure */
typedef struct {
	I2				width;			/* image size horizontal(dot)	*/
	I2				height;			/* image size vertical(dot)		*/
	U1				orientation;	/* orientation					*/
	U1				reserved[3];	/* reserved						*/
	U1				datetime[20];	/* datetime						*/
} JPEG_IMG_INFO;

/*
 * ///// definition of functions prototype /////
 */
extern U4  _PutImageJPEG(DRAW_AREA_INFO *draw_area, DRAW_IMG_INFO *draw_img, int *stop_flag);
extern U4  _GetImageJPEG(DRAW_IMG_INFO *draw_img, JPEG_IMG_INFO *jpeg_img_info);


#endif	/* _DRAWJPEG_H */
